<?php

use Illuminate\Support\Facades\Route;


Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::get('/setting', 'HomeController@setting')->name('setting');


//admin
Route::group(['middleware' => ['role:admin','auth'] ,'prefix' => 'admin'], function () {

    Route::get('dashboard', [
    'uses' =>'Admin\AdminController@dashboard',
    'as' => 'admin.dashboard'
    ]);

    Route::get('my-profile', [
    'uses' =>'Admin\AdminController@my_profile',
    'as' => 'admin.my_profile'
    ]);

    ////////////////Products Route Start//////////////////

    Route::get('product/add/', [
    'uses' =>'Admin\AdminController@productCreate',
    'as' => 'admin.productCreate'
    ]);

    Route::get('product/list', [
    'uses' =>'Admin\AdminController@productsAll',
    'as' => 'admin.productsAll'
    ]);

    Route::get('product/edit/product/{product}', [
    'uses' =>'Admin\AdminController@productEdit',
    'as' => 'admin.productEdit'
    ]);

    Route::post('product/update/product/{product}', [
    'uses' =>'Admin\AdminController@productUpdate',
    'as' => 'admin.productUpdate'
    ]);

    Route::get('product/delete/product/{product}', [
    'uses' =>'Admin\AdminController@productDelete',
    'as' => 'admin.productDelete'
    ]);


    ////////////////Products Route Start//////////////////


    ////////////////Catagories Route Start//////////////////

    Route::get('category/list', [
    'uses' =>'Admin\AdminController@categoryAll',
    'as' => 'admin.categoryAll'
    ]);

    Route::post('category/post', [
    'uses' =>'Admin\AdminController@categoryPost',
    'as' => 'admin.categoryPost'
    ]);

    Route::get('category/edit/{catagory}', [
    'uses' =>'Admin\AdminController@categoryEdit',
    'as' => 'admin.categoryEdit'
    ]);

    Route::post('category/update/{catagory}', [
    'uses' =>'Admin\AdminController@categoryUpdate',
    'as' => 'admin.categoryUpdate'
    ]);

    Route::get('category/delete/{catagory}', [
    'uses' =>'Admin\AdminController@categoryDelete',
    'as' => 'admin.categoryDelete'
    ]);


    ////////////////Catagories Route Start//////////////////

    ////////////////Brands Route Start//////////////////

        Route::get('brand/list', [
        'uses' =>'Admin\AdminController@brandAll',
        'as' => 'admin.brandAll'
        ]);
        
        Route::post('brand/post', [
        'uses' =>'Admin\AdminController@brandPost',
        'as' => 'admin.brandPost'
        ]);

        Route::get('brand/edit/{brand}', [
        'uses' =>'Admin\AdminController@brandEdit',
        'as' => 'admin.brandEdit'
        ]);

        Route::post('brand/update/{brand}', [
        'uses' =>'Admin\AdminController@brandUpdate',
        'as' => 'admin.brandUpdate'
        ]);

        Route::get('brand/delete/{brand}', [
        'uses' =>'Admin\AdminController@brandDelete',
        'as' => 'admin.brandDelete'
        ]);

    ////////////////Brands Route End//////////////////


    ////////////////Color Route Start//////////////////

        Route::get('color/list', [
        'uses' =>'Admin\AdminController@colorAll',
        'as' => 'admin.colorAll'
        ]);

        Route::post('color/post', [
        'uses' =>'Admin\AdminController@colorPost',
        'as' => 'admin.colorPost'
        ]);

        Route::get('color/edit/{color}', [
        'uses' =>'Admin\AdminController@colorEdit',
        'as' => 'admin.colorEdit'
        ]);

        Route::post('color/update/{color}', [
        'uses' =>'Admin\AdminController@colorUpdate',
        'as' => 'admin.colorUpdate'
        ]);

        Route::get('color/delete/{color}', [
        'uses' =>'Admin\AdminController@colorDelete',
        'as' => 'admin.colorDelete'
        ]);

    ////////////////Color Route End//////////////////


    ////////////////Size Route Start//////////////////


        Route::get('size/list', [
        'uses' =>'Admin\AdminController@sizeAll',
        'as' => 'admin.sizeAll'
        ]);
        Route::post('size/post', [
        'uses' =>'Admin\AdminController@sizePost',
        'as' => 'admin.sizePost'
        ]);
        Route::get('size/edit/{size}', [
        'uses' =>'Admin\AdminController@sizeEdit',
        'as' => 'admin.sizeEdit'
        ]);

        Route::post('size/update/{size}', [
        'uses' =>'Admin\AdminController@sizeUpdate',
        'as' => 'admin.sizeUpdate'
        ]);

        Route::get('size/delete/{size}', [
        'uses' =>'Admin\AdminController@sizeDelete',
        'as' => 'admin.sizeDelete'
        ]);

    ////////////////Size Route End//////////////////


    ////////////////Review Route End//////////////////
        Route::get('review/list', [
        'uses' =>'Admin\AdminController@reviewAll',
        'as' => 'admin.reviewAll'
        ]);

        Route::get('review/view/{product}', [
        'uses' =>'Admin\AdminController@reviewView',
        'as' => 'admin.reviewView'
        ]);

        Route::post('review/update/{product}', [
        'uses' =>'Admin\AdminController@reviewUpdate',
        'as' => 'admin.reviewUpdate'
        ]);

        Route::get('review/delete/{product}', [
        'uses' =>'Admin\AdminController@reviewDelete',
        'as' => 'admin.reviewDelete'
        ]);

    ////////////////Review Route End//////////////////


    ////////////////Orders Route Start//////////////////
     Route::get('orders/completed', [
        'uses' =>'Admin\AdminController@ordersCompleted',
        'as' => 'admin.ordersCompleted'
        ]);

      Route::get('orders/panding', [
        'uses' =>'Admin\AdminController@ordersPanding',
        'as' => 'admin.ordersPanding'
        ]);
     Route::get('orders/Approved', [
        'uses' =>'Admin\AdminController@ordersAppoved',
        'as' => 'admin.ordersAppoved'
        ]);
      Route::get('orders/ondelivery', [
        'uses' =>'Admin\AdminController@ordersOndelivery',
        'as' => 'admin.ordersOndelivery'
        ]);
       Route::get('orders/ordercancel', [
        'uses' =>'Admin\AdminController@orderCancel',
        'as' => 'admin.orderCancel'
        ]);
        Route::get('orders/orderreturn', [
        'uses' =>'Admin\AdminController@orderReturn',
        'as' => 'admin.orderReturn'
        ]);
    ////////////////Orders Route End//////////////////


    ////////////////Pages Route Start//////////////////
        Route::get('pages/list', [
        'uses' =>'Admin\AdminController@pagesAll',
        'as' => 'admin.pagesAll'
        ]);

        Route::get('pages/create', [
        'uses' =>'Admin\AdminController@pageCreate',
        'as' => 'admin.pageCreate'
        ]);

        Route::post('pages/post', [
        'uses' =>'Admin\AdminController@pagePost',
        'as' => 'admin.pagePost'
        ]);

        Route::get('pages/edit/{page}', [
        'uses' =>'Admin\AdminController@pageEdit',
        'as' => 'admin.pageEdit'
        ]);
        Route::post('pages/update/{page}', [
        'uses' =>'Admin\AdminController@pageUpdate',
        'as' => 'admin.pageUpdate'
        ]);
        Route::get('pages/delete/{page}', [
        'uses' =>'Admin\AdminController@pageDelete',
        'as' => 'admin.pageDelete'
        ]);
    ////////////////Pages Route End//////////////////


    ////////////////Posts Route Start//////////////////
        Route::get('posts/list', [
        'uses' =>'Admin\AdminController@postsAll',
        'as' => 'admin.postsAll'
        ]);

        Route::get('posts/create', [
        'uses' =>'Admin\AdminController@postCreate',
        'as' => 'admin.postCreate'
        ]);

        Route::post('posts/post', [
        'uses' =>'Admin\AdminController@postPost',
        'as' => 'admin.postPost'
        ]);

        Route::get('posts/edit/{post}', [
        'uses' =>'Admin\AdminController@postEdit',
        'as' => 'admin.postEdit'
        ]);
        Route::post('posts/update/{post}', [
        'uses' =>'Admin\AdminController@postUpdate',
        'as' => 'admin.postUpdate'
        ]);
        Route::get('posts/delete/{post}', [
        'uses' =>'Admin\AdminController@postDelete',
        'as' => 'admin.postDelete'
        ]);

    ////////////////Posts Route End//////////////////


    ////////////////Posts Catagory Route Start//////////////////
        Route::get('posts/catagories', [
        'uses' =>'Admin\AdminController@postcatagories',
        'as' => 'admin.postcatagories'
        ]);

        Route::get('posts/catagories/edit/{catagory}', [
        'uses' =>'Admin\AdminController@postcatagoriesEdit',
        'as' => 'admin.postcatagoriesEdit'
        ]);
    ////////////////Posts Catagory Route End//////////////////


    ////////////////Posts Tags Route Start//////////////////
        Route::get('posts/tags', [
        'uses' =>'Admin\AdminController@posttags',
        'as' => 'admin.posttags'
        ]);

        Route::get('posts/tags/edit/{tag}', [
        'uses' =>'Admin\AdminController@posttagEdit',
        'as' => 'admin.posttagEdit'
        ]);

    ////////////////Posts Tags Route End//////////////////


    ////////////////Admin Users Route Start//////////////////
     Route::get('users/admin-users', [
        'uses' =>'Admin\AdminController@admin_users',
        'as' => 'admin.admin_users'
        ]);

     Route::get('users/admin-users/add', [
        'uses' =>'Admin\AdminController@admin_userCreate',
        'as' => 'admin.admin_userCreate'
        ]);

     Route::get('users/admin-users/view/{user}', [
        'uses' =>'Admin\AdminController@admin_userView',
        'as' => 'admin.admin_userView'
        ]);

      Route::get('users/customer-users', [
        'uses' =>'Admin\AdminController@customer_users',
        'as' => 'admin.customer_users'
        ]);


       Route::get('users/seller-users', [
        'uses' =>'Admin\AdminController@seller_users',
        'as' => 'admin.seller_users'
        ]);
    ////////////////Admin Users Route End//////////////////



    ////////////////User Roles Route Start//////////////////
    
    Route::get('roles/list', [
    'uses' =>'Admin\AdminController@rolesAll',
    'as' => 'admin.rolesAll'
    ]);

    Route::get('roles/add', [
    'uses' =>'Admin\AdminController@roleCreate',
    'as' => 'admin.roleCreate'
    ]);

    Route::post('roles/post', [
    'uses' =>'Admin\AdminController@roleCreatePost',
    'as' => 'admin.roleCreatePost'
    ]);

    Route::get('roles/edit/{role}', [
    'uses' =>'Admin\AdminController@roleEdit',
    'as' => 'admin.roleEdit'
    ]);

    ////////////////User Roles Route End//////////////////


    ////////////////App Setting Route Start//////////////////

    Route::get('setting/list', [
    'uses' =>'Admin\AdminController@settingAll',
    'as' => 'admin.settingAll'
    ]);

     Route::get('mail-notification', [
    'uses' =>'Admin\AdminController@mail_notification',
    'as' => 'admin.mail_notification'
    ]);

    ////////////////App Setting Route End//////////////////


 });

 


//vendor

 Route::get('/dashboard/seller', [
    'uses' =>'WelcomeController@dashboard',
    'as' => 'seller.dashboard'
    ]);






Route::group(['middleware' => ['role:seller','auth'] ,'prefix' => 'seller'], function () {

    Route::get('/dashboard/seller/{seller}', [
    'uses' =>'Seller\SellerController@dashboard',
    'as' => 'seller.dashboard'
    ]);

 });
